<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/partials/header.php';
require_once __DIR__.'/partials/navbar.php';
$pass = null;
if ($_SERVER['REQUEST_METHOD']==='POST') {
  check_csrf();
  $num = trim($_POST['pass_number'] ?? '');
  $stmt = $mysqli->prepare("SELECT p.*, c.name AS category FROM passes p JOIN categories c ON c.id = p.category_id WHERE p.pass_number=?");
  $stmt->bind_param('s',$num);
  $stmt->execute();
  $pass = $stmt->get_result()->fetch_assoc();
}
?>
<div class="container my-5" style="max-width:720px;">
  <h2 class="mb-4">View / Print Pass</h2>
  <form method="post" class="card card-body mb-4">
    <?php csrf_field(); ?>
    <label class="form-label">Enter Pass Number</label>
    <input type="text" name="pass_number" class="form-control" required placeholder="e.g., BP-2025-0001">
    <button class="btn btn-primary mt-3">Search</button>
  </form>
  <?php if ($pass): ?>
    <div class="card">
      <div class="card-header d-flex justify-content-between">
        <strong>Pass #<?php echo e($pass['pass_number']); ?></strong>
        <button onclick="window.print()" class="btn btn-sm btn-outline-secondary">Print</button>
      </div>
      <div class="card-body">
        <p><strong>Name:</strong> <?php echo e($pass['user_name']); ?></p>
        <p><strong>Email:</strong> <?php echo e($pass['user_email']); ?></p>
        <p><strong>Category:</strong> <?php echo e($pass['category']); ?></p>
        <p><strong>Validity:</strong> <?php echo e($pass['valid_from']); ?> to <?php echo e($pass['valid_to']); ?></p>
        <p><strong>Status:</strong> <?php echo e($pass['status']); ?></p>
        <?php if (!empty($pass['photo_url'])): ?>
          <img src="<?php echo e($pass['photo_url']); ?>" class="img-fluid rounded" style="max-height:200px" alt="pass photo">
        <?php endif; ?>
      </div>
    </div>
  <?php elseif($_SERVER['REQUEST_METHOD']==='POST'): ?>
    <div class="alert alert-warning">No pass found with that number.</div>
  <?php endif; ?>
</div>
<?php require_once __DIR__.'/partials/footer.php'; ?>
