<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_once __DIR__.'/../helpers.php';
require_admin();
$rows = [];
if ($_SERVER['REQUEST_METHOD']==='POST') {
  check_csrf();
  $from = $_POST['from']; $to = $_POST['to'];
  $stmt = $mysqli->prepare("SELECT p.*, c.name AS category FROM passes p JOIN categories c ON c.id=p.category_id WHERE DATE(p.created_at) BETWEEN ? AND ? ORDER BY p.created_at DESC");
  $stmt->bind_param('ss',$from,$to);
  $stmt->execute(); $rows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Reports</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center">
    <h3>Reports</h3>
    <a class="btn btn-secondary" href="/admin/dashboard.php">Back</a>
  </div>
  <form method="post" class="card card-body my-3">
    <?php csrf_field(); ?>
    <div class="row g-3 align-items-end">
      <div class="col-md-3"><label class="form-label">From</label><input class="form-control" type="date" name="from" required></div>
      <div class="col-md-3"><label class="form-label">To</label><input class="form-control" type="date" name="to" required></div>
      <div class="col-md-2"><button class="btn btn-primary w-100">Generate</button></div>
    </div>
  </form>
  <?php if($rows): ?>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <thead><tr><th>Created</th><th>Pass #</th><th>Name</th><th>Email</th><th>Category</th><th>Validity</th><th>Status</th><th>Price</th></tr></thead>
      <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?php echo $r['created_at']; ?></td>
          <td><?php echo htmlspecialchars($r['pass_number']); ?></td>
          <td><?php echo htmlspecialchars($r['user_name']); ?></td>
          <td><?php echo htmlspecialchars($r['user_email']); ?></td>
          <td><?php echo htmlspecialchars($r['category']); ?></td>
          <td><?php echo htmlspecialchars($r['valid_from'].' → '.$r['valid_to']); ?></td>
          <td><?php echo htmlspecialchars($r['status']); ?></td>
          <td><?php echo htmlspecialchars($r['price']); ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <?php endif; ?>
</div>
</body></html>
