<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_admin();
$id = (int)($_GET['id'] ?? 0);
$stmt = $mysqli->prepare("SELECT p.*, c.name AS category FROM passes p JOIN categories c ON c.id=p.category_id WHERE p.id=?");
$stmt->bind_param('i',$id); $stmt->execute(); $r = $stmt->get_result()->fetch_assoc();
if (!$r) { die('Pass not found'); }
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Print Pass #<?php echo htmlspecialchars($r['pass_number']); ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>.card{ width: 720px; margin: 2rem auto; }</style>
</head><body onload="window.print()">
<div class="card">
  <div class="card-header d-flex justify-content-between">
    <strong>Bus Pass</strong><span>#<?php echo htmlspecialchars($r['pass_number']); ?></span>
  </div>
  <div class="card-body">
    <div class="row">
      <div class="col-8">
        <p><strong>Name:</strong> <?php echo htmlspecialchars($r['user_name']); ?></p>
        <p><strong>Email:</strong> <?php echo htmlspecialchars($r['user_email']); ?></p>
        <p><strong>Category:</strong> <?php echo htmlspecialchars($r['category']); ?></p>
        <p><strong>Validity:</strong> <?php echo htmlspecialchars($r['valid_from']); ?> to <?php echo htmlspecialchars($r['valid_to']); ?></p>
        <p><strong>Status:</strong> <?php echo htmlspecialchars($r['status']); ?></p>
      </div>
      <div class="col-4 text-end">
        <?php if(!empty($r['photo_url'])): ?>
          <img src="<?php echo htmlspecialchars($r['photo_url']); ?>" class="img-fluid rounded border" alt="photo">
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
</body></html>
