<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_once __DIR__.'/../helpers.php';
if (is_admin()) { header('Location: /admin/dashboard.php'); exit; }
$error = null;
if ($_SERVER['REQUEST_METHOD']==='POST') {
  check_csrf();
  $email = trim($_POST['email']??'');
  $pass = $_POST['password']??'';
  $stmt = $mysqli->prepare("SELECT id,name,email,password_hash,role FROM users WHERE email=? AND role='admin'");
  $stmt->bind_param('s',$email);
  $stmt->execute();
  $u = $stmt->get_result()->fetch_assoc();
  if ($u && password_verify($pass, $u['password_hash'])) {
    $_SESSION['user'] = ['id'=>$u['id'],'name'=>$u['name'],'email'=>$u['email'],'role'=>$u['role']];
    header('Location: /admin/dashboard.php'); exit;
  } else {
    $error = 'Invalid credentials.';
  }
}
?>
<!doctype html><html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container" style="max-width:480px;">
  <div class="card shadow mt-5">
    <div class="card-body">
      <h3 class="mb-3">Admin Login</h3>
      <?php if($error): ?><div class="alert alert-danger"><?php echo e($error); ?></div><?php endif; ?>
      <form method="post">
        <?php csrf_field(); ?>
        <label class="form-label">Email</label>
        <input class="form-control" name="email" type="email" required>
        <label class="form-label mt-3">Password</label>
        <input class="form-control" name="password" type="password" required>
        <button class="btn btn-primary w-100 mt-4">Login</button>
      </form>
      <div class="text-center mt-3"><a href="/public/index.php">Back to site</a></div>
    </div>
  </div>
</div>
</body></html>
