# Bus Pass Management System (PHP + MySQL)

Industrial-style, two-module application (User + Admin). No `.env` needed.

## Features

**Admin**
- Dashboard with totals (categories, passes: today / yesterday / last 7 days)
- Categories: add/update/delete
- Passes: add/update/delete and print
- Pages: edit About and Contact
- Enquiries: view messages from contact form
- Reports: generate pass reports between two dates
- Search: lookup pass by pass number
- Profile: update name and change password

**User**
- Landing page with professional hero, categories, and featured passes
- View Pass: lookup by pass number and print
- About / Contact pages

## Quick Start

1. Copy the project to your PHP server root (e.g., `htdocs` or `public_html`).
2. Ensure PHP 8+ and MySQL 5.7+ / MariaDB are available.
3. Update `config.php` DB credentials if needed.
4. Create the database and seed it:
   - Create an empty DB named in `config.php` (default: `bus_pass_db`), OR let the seeder create it.
   - Run the seeder in the browser: `http://your-host/seed/seed.php`
     - Optional overrides: `?email=you@example.com&password=StrongPass!23`
5. Visit `http://your-host/admin/login.php` and sign in:
   - Default: **admin@example.com / **`Admin@123`** (change after login).
6. Public site: `http://your-host/public/index.php`

## Tech
- PHP (procedural, mysqli, prepared statements)
- Bootstrap 5 (CDN)
- MySQL (schema in `database.sql`)
- Minimal CSRF protection for admin forms
- Simple SVG hero image (no external assets)

## Notes
- Change the default admin password immediately.
- For printing, use the browser's print dialog (pass and admin print views are styled).
- This scaffold is intentionally clean and small; extend as needed.
