<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_once __DIR__.'/../helpers.php';
require_admin();
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $stmt = $mysqli->prepare("UPDATE pages SET title=?, content=?, updated_at=NOW() WHERE slug=?");
  $stmt->bind_param('sss', $_POST['title'], $_POST['content'], $_POST['slug']);
  $stmt->execute();
  header('Location: /admin/pages.php'); exit;
}
$pages = $mysqli->query("SELECT * FROM pages ORDER BY slug ASC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Pages</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center">
    <h3>Pages</h3>
    <a class="btn btn-secondary" href="/admin/dashboard.php">Back</a>
  </div>
  <?php while($p=$pages->fetch_assoc()): ?>
    <div class="card card-body my-3">
      <form method="post">
        <?php csrf_field(); ?>
        <input type="hidden" name="slug" value="<?php echo $p['slug']; ?>">
        <div class="row g-3">
          <div class="col-md-4"><input class="form-control" name="title" value="<?php echo e($p['title']); ?>"></div>
          <div class="col-md-8"><textarea class="form-control" name="content" rows="6"><?php echo e($p['content']); ?></textarea></div>
        </div>
        <button class="btn btn-primary mt-3">Save</button>
      </form>
    </div>
  <?php endwhile; ?>
</div>
</body></html>
