<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_admin();
$today = $mysqli->query("SELECT COUNT(*) c FROM passes WHERE DATE(created_at)=CURDATE()")->fetch_assoc()['c'] ?? 0;
$yday = $mysqli->query("SELECT COUNT(*) c FROM passes WHERE DATE(created_at)=DATE_SUB(CURDATE(), INTERVAL 1 DAY)")->fetch_assoc()['c'] ?? 0;
$week = $mysqli->query("SELECT COUNT(*) c FROM passes WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)")->fetch_assoc()['c'] ?? 0;
$cats = $mysqli->query("SELECT COUNT(*) c FROM categories")->fetch_assoc()['c'] ?? 0;
?>
<!doctype html><html lang="en"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Admin Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body>
<nav class="navbar navbar-dark bg-dark"><div class="container">
  <a class="navbar-brand" href="/admin/dashboard.php">BPMS Admin</a>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-light btn-sm" href="/admin/categories.php">Categories</a>
    <a class="btn btn-outline-light btn-sm" href="/admin/passes.php">Passes</a>
    <a class="btn btn-outline-light btn-sm" href="/admin/pages.php">Pages</a>
    <a class="btn btn-outline-light btn-sm" href="/admin/enquiries.php">Enquiries</a>
    <a class="btn btn-outline-light btn-sm" href="/admin/reports.php">Reports</a>
    <a class="btn btn-outline-light btn-sm" href="/admin/search.php">Search</a>
    <a class="btn btn-warning btn-sm" href="/admin/logout.php">Logout</a>
  </div>
</div></nav>
<div class="container my-4">
  <div class="row g-3">
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Total Categories</h6><div class="display-6"><?php echo $cats; ?></div></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Passes Today</h6><div class="display-6"><?php echo $today; ?></div></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Passes Yesterday</h6><div class="display-6"><?php echo $yday; ?></div></div></div></div>
    <div class="col-md-3"><div class="card"><div class="card-body"><h6>Last 7 Days</h6><div class="display-6"><?php echo $week; ?></div></div></div></div>
  </div>
</div>
</body></html>
